/*
 * Decompiled with CFR 0.152.
 */
package me.fixfis.sUHCore.mobs;

import io.papermc.paper.datacomponent.DataComponentTypes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import me.fixfis.sUHCore.SUHCore;
import me.fixfis.sUHCore.items.SUHItems;
import me.fixfis.sUHCore.lootable.LootTable;
import me.fixfis.sUHCore.mobs.modMobs.EntityAttributes;
import me.fixfis.sUHCore.mobs.modMobs.mobs.FEntity;
import me.fixfis.sUHCore.mobs.modMobs.mobs.FInteraction;
import me.fixfis.sUHCore.mobs.modMobs.mobs.FLivingEntities;
import me.fixfis.sUHCore.mobs.modMobs.mobs.FLootEntity;
import me.fixfis.sUHCore.mobs.modMobs.mobs.FMonster;
import me.fixfis.sUHCore.mobs.modMobs.mobs.FStandEntity;
import me.fixfis.sUHCore.mobs.modMobs.mobs.special.SpecialAbilities;
import me.fixfis.sUHCore.muertes.interfaz.RevivirIntefaz;
import me.fixfis.sUHCore.sever_client.ClientUtils;
import me.fixfis.sUHCore.specialEvents.EncadenadoMap;
import me.fixfis.sUHCore.utils.OffTopic;
import net.kyori.adventure.key.Key;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Bat;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Interaction;
import org.bukkit.entity.LightningStrike;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.entity.Rabbit;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.Snowball;
import org.bukkit.entity.Spider;
import org.bukkit.entity.Wolf;
import org.bukkit.entity.Zombie;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public enum SUHMobs {
    LOBO_SANGRIENTO((FEntity<? extends Entity>)new FMonster<Wolf>(Wolf.class, "loboSangriento", null){

        @Override
        public void initViewMonster(Wolf entity) {
            entity.setCustomNameVisible(true);
            entity.setCustomName("Lobo Sangriento");
        }

        @Override
        protected void onPlayerDamagedByThisEntity(Wolf entity, Player player, EntityDamageByEntityEvent event) {
            player.addPotionEffect(new PotionEffect(PotionEffectType.POISON, 100, 2, false, false));
        }
    }),
    KCAFETERO((FEntity<? extends Entity>)new FLivingEntities<Rabbit>(Rabbit.class, "kcafetero"){

        @Override
        protected void initViewPeaceful(Rabbit entity) {
            entity.getEquipment().setHelmet(2.getInvibleHelmet(Material.STICK));
            entity.getAttribute(Attribute.FALL_DAMAGE_MULTIPLIER).setBaseValue(0.0);
            entity.getAttribute(Attribute.KNOCKBACK_RESISTANCE).setBaseValue(0.0);
        }

        @Override
        protected void onThisEntityDamaged(Rabbit entity, EntityDamageEvent event) {
            entity.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, 100, 2, false, false));
            entity.addPotionEffect(new PotionEffect(PotionEffectType.JUMP_BOOST, 100, 1, false, false));
        }

        @Override
        protected void thisEntityDrops(List<ItemStack> drops) {
            drops.clear();
            drops.add(SUHItems.COMIDA_CAFE.getItemStack());
        }
    }),
    ZOMBIE_SCRAMBLE((FEntity<? extends Entity>)new FMonster<Zombie>(Zombie.class, "zombieScramble", EntityAttributes.ZOMBIE){

        @Override
        public void initViewMonster(Zombie entity) {
            entity.getEquipment().setHelmet(3.getItemstackWhitItemModel(Material.STICK, "rubik"));
            entity.setCustomName("Zombie Scramble");
        }

        @Override
        protected void onPlayerDamagedByThisEntity(Zombie entity, Player player, EntityDamageByEntityEvent event) {
            FEntity.particleToEntity((Entity)entity, Particle.CAMPFIRE_COSY_SMOKE);
            entity.remove();
            SpecialAbilities.ABILITY_SCRAMBLE_TO_PLAYER.getSpecialClass().doThis(player, (Monster)entity);
        }
    }),
    ZOMBIE_THROWER((FEntity<? extends Entity>)new FMonster<Zombie>(Zombie.class, "zombieThrower", EntityAttributes.ZOMBIE){

        @Override
        public void initViewMonster(Zombie entity) {
            entity.getEquipment().setHelmet(4.getInvibleHelmet(Material.IRON_BARS));
        }

        @Override
        protected void onPlayerDamagedByThisEntity(Zombie entity, Player player, EntityDamageByEntityEvent event) {
            SpecialAbilities.ABILITY_EMPUJAR.getSpecialClass().doThis(player, (Monster)entity);
        }
    }),
    ZOMBIE_DIVIDER((FEntity<? extends Entity>)new FMonster<Zombie>(Zombie.class, "zombieDivider", EntityAttributes.ZOMBIE){

        @Override
        public void initViewMonster(Zombie entity) {
            entity.getEquipment().setHelmet(5.getInvibleHelmet(Material.SLIME_BALL));
        }

        @Override
        protected void onThisEntityDamagedByPlayerByArrow(Arrow arrow, Zombie entity, Player player, EntityDamageByEntityEvent event) {
            this.onThisEntityDamagedByPlayer(entity, player, event);
        }

        @Override
        protected void onThisEntityDamagedByPlayer(Zombie entity, Player player, EntityDamageByEntityEvent event) {
            if (entity.getScoreboardTags().contains("divided")) {
                return;
            }
            entity.getScoreboardTags().add("divided");
            double scale = entity.getAttribute(Attribute.SCALE).getValue() * 0.85;
            double speed = entity.getAttribute(Attribute.MOVEMENT_SPEED).getValue() * 1.2;
            for (int i = 0; i < 2; ++i) {
                Zombie zombie = (Zombie)SUHMobs.valueOf((String)"ZOMBIE_DIVIDER").fEntity.summonEntity(entity.getLocation());
                zombie.getScoreboardTags().add("nodi");
                zombie.getEquipment().setHelmet(5.getInvibleHelmet(Material.SLIME_BALL));
                if (entity.getScoreboardTags().contains("nodi")) {
                    zombie.getScoreboardTags().add("divided");
                }
                Bukkit.getScheduler().runTaskLater((Plugin)SUHCore.instance, () -> {
                    zombie.getAttribute(Attribute.SCALE).setBaseValue(scale);
                    zombie.getAttribute(Attribute.MOVEMENT_SPEED).setBaseValue(speed);
                }, 1L);
            }
        }
    }),
    ZOMBIE_INFECTADO((FEntity<? extends Entity>)new FMonster<Zombie>(Zombie.class, "zombieInfectado", EntityAttributes.ZOMBIE){

        @Override
        public void initViewMonster(Zombie entity) {
            entity.getEquipment().setHelmet(6.getInvibleHelmet(Material.APPLE));
        }
    }),
    ZOMBIE_PLEBE((FEntity<? extends Entity>)new FMonster<Zombie>(Zombie.class, "zombiePlebe", EntityAttributes.ZOMBIE){

        @Override
        public void initViewMonster(Zombie entity) {
            entity.getScoreboardTags().add("ntp");
            entity.setBaby();
        }
    }),
    SKELETON_COBWEB((FEntity<? extends Entity>)new FMonster<Skeleton>(Skeleton.class, "skeletonCobweb", EntityAttributes.SKELETON){

        @Override
        public void initViewMonster(Skeleton entity) {
            entity.getEquipment().setHelmet(8.getInvibleHelmet(Material.COBWEB));
            entity.setCustomName("Skeleton Cobweb");
        }

        @Override
        protected void onPlayerDamagedByThisEntityByArrow(Arrow arrow, Skeleton entity, Player player, EntityDamageByEntityEvent event) {
            player.getLocation().getBlock().setType(Material.COBWEB);
        }
    }),
    SKELETON_TP((FEntity<? extends Entity>)new FMonster<Skeleton>(Skeleton.class, "skeletonTpwa", EntityAttributes.SKELETON){

        @Override
        public void initViewMonster(Skeleton entity) {
            entity.getEquipment().setHelmet(9.getInvibleHelmet(Material.END_STONE));
            entity.setCustomName("Skeleton TP");
        }

        @Override
        protected void onPlayerDamagedByThisEntityByArrow(Arrow arrow, Skeleton entity, Player player, EntityDamageByEntityEvent event) {
            SpecialAbilities.ABILITY_SWITCH_LOCATION.getSpecialClass().doThis(player, (Monster)entity);
        }
    }),
    SKELETON_RAYO((FEntity<? extends Entity>)new FMonster<Skeleton>(Skeleton.class, "skeletonrayo", EntityAttributes.SKELETON){

        @Override
        public void initViewMonster(Skeleton entity) {
            entity.getEquipment().setHelmet(10.getInvibleHelmet(Material.SLIME_BALL));
            entity.setCustomNameVisible(true);
            entity.setCustomName("Skeleton Rayo");
        }

        @Override
        protected void onPlayerDamagedByThisEntityByArrow(Arrow arrow, Skeleton entity, Player player, EntityDamageByEntityEvent event) {
            player.getWorld().spawn(player.getLocation(), LightningStrike.class);
        }
    }),
    CREEPER_SCRAMBLE((FEntity<? extends Entity>)new FMonster<Creeper>(Creeper.class, "creeperScramble", EntityAttributes.CREEPER){
        private final Map<UUID, BukkitRunnable> scramblePlayers = new HashMap<UUID, BukkitRunnable>();

        @Override
        public void initViewMonster(Creeper entity) {
            entity.getEquipment().setHelmet(11.getInvibleHelmet(Material.SLIME_BALL));
        }

        @Override
        protected void onPlayerDamagedByThisEntity(Creeper entity, final Player player, EntityDamageByEntityEvent event) {
            BukkitRunnable task = new BukkitRunnable(){

                public void run() {
                    scramblePlayers.remove(player.getUniqueId());
                    ClientUtils.sendDataToClient(player, "scrambled", 0);
                }
            };
            if (this.scramblePlayers.containsKey(player.getUniqueId())) {
                this.scramblePlayers.get(player.getUniqueId()).cancel();
            }
            ClientUtils.sendDataToClient(player, "scrambled", 1);
            task.runTaskLater((Plugin)SUHCore.instance, 140L);
            this.scramblePlayers.put(player.getUniqueId(), task);
        }
    }),
    CREEPER_TNT((FEntity<? extends Entity>)new FMonster<Creeper>(Creeper.class, "creeper_tnt", EntityAttributes.CREEPER){

        @Override
        public void initViewMonster(Creeper entity) {
            entity.getEquipment().setHelmet(12.getInvibleHelmet(Material.TNT));
        }

        @Override
        protected void onPlayerDamagedByThisEntity(Creeper entity, Player player, EntityDamageByEntityEvent event) {
            player.playSound((Entity)player, "entity.tin", 1.0f, 1.0f);
        }
    }),
    CREEPER_BOMBA((FEntity<? extends Entity>)new FMonster<Creeper>(Creeper.class, "creeperBomba", EntityAttributes.CREEPER){

        @Override
        public void initViewMonster(Creeper entity) {
            entity.getEquipment().setHelmet(new ItemStack(Material.PAPER));
        }

        @Override
        protected void onPlayerDamagedByThisEntity(Creeper entity, Player player, EntityDamageByEntityEvent event) {
            EncadenadoMap.addUser(player);
        }
    }),
    CREEPER_FLASH((FEntity<? extends Entity>)new FMonster<Creeper>(Creeper.class, "creeper_flash", EntityAttributes.CREEPER){

        @Override
        public void initViewMonster(Creeper entity) {
            entity.getEquipment().setHelmet(new ItemStack(Material.STICK));
        }

        @Override
        protected void onPlayerDamagedByThisEntity(Creeper entity, Player player, EntityDamageByEntityEvent event) {
            ClientUtils.sendDataToClient(player, "flashed", 1);
            player.playSound((Entity)player, "entity.tin", 1.0f, 1.0f);
        }
    }),
    SPIDER_THROW_COBWEB((FEntity<? extends Entity>)new FMonster<Spider>(Spider.class, "arranita", EntityAttributes.SPIEDER){

        @Override
        public void initViewMonster(Spider entity) {
        }

        @Override
        public void onThisEntityTargetPlayer(Spider entity, Player player, EntityTargetLivingEntityEvent event) {
            Location from = entity.getEyeLocation().add(0.0, 1.0, 0.0);
            Location to = player.getLocation().add(0.0, 1.5, 0.0);
            double gravity = 0.03;
            double flightTime = 1.0;
            Vector velocity = OffTopic.calculateBallisticVelocity(from, to, gravity, flightTime);
            Snowball snowball = (Snowball)entity.launchProjectile(Snowball.class);
            snowball.setShooter((ProjectileSource)entity);
            snowball.setVelocity(velocity);
        }
    }),
    BLOOD_BAT((FEntity<? extends Entity>)new FLivingEntities<Bat>(Bat.class, "blood_bat"){

        @Override
        protected void initViewPeaceful(Bat entity) {
            entity.getEquipment().setHelmet(16.getInvibleHelmet(Material.STICK));
        }

        @Override
        protected void thisEntityDrops(List<ItemStack> drops) {
            drops.clear();
            drops.add(SUHItems.UTILS_BOLSA_SANGRE.getItemStack());
        }
    }),
    ORE_TITANIUM((FEntity<? extends Entity>)new FLivingEntities<Zombie>(Zombie.class, "ore_titanium"){

        @Override
        protected void initViewPeaceful(Zombie entity) {
            entity.setAI(false);
            entity.setSilent(true);
            entity.setInvisible(true);
            entity.setBaby();
            Location location = entity.getLocation();
            location.setPitch(0.0f);
            entity.teleport(location);
            entity.getEquipment().setHelmet(SUHItems.ORE_TITANIUM.getItemStack());
            Objects.requireNonNull(entity.getAttribute(Attribute.SCALE)).setBaseValue(0.5);
        }

        @Override
        protected void onThisEntityDamaged(Zombie entity, EntityDamageEvent event) {
            event.setCancelled(true);
        }

        @Override
        protected void onThisEntityDamagedByPlayer(Zombie entity, Player player, EntityDamageByEntityEvent event) {
            if (player.getInventory().getItemInMainHand().getType() == Material.DIAMOND_PICKAXE) {
                event.setCancelled(false);
            } else {
                event.setCancelled(true);
            }
        }
    }),
    MISIONATTRIL(new FStandEntity("misionattril"){

        @Override
        protected void initViewStand(ArmorStand entity) {
            entity.setCustomName("Mision Attr");
            entity.setCustomNameVisible(true);
            entity.setGravity(false);
            entity.setBasePlate(false);
            entity.setArms(false);
            entity.setVisible(false);
            entity.setInvulnerable(true);
            entity.getAttribute(Attribute.SCALE).setBaseValue(1.6);
            entity.getEquipment().setHelmet(SUHItems.MISION_STAND.getItemStack());
        }

        @Override
        protected void onRightClickAtEntityEvent(Player player, ArmorStand entity, PlayerInteractAtEntityEvent event) {
            player.sendMessage("dado");
        }
    }),
    SUH_MISIONES(new FInteraction("suhmision", 2.0f, 3.0f){

        @Override
        protected void onRightClickAtEntityEvent(@NotNull Player player, Interaction rightClicked, PlayerInteractAtEntityEvent event) {
            if (player == null) {
                19.$$$reportNull$$$0(0);
            }
            player.sendMessage("dado");
            this.playAnimation("redeem", rightClicked, "hold").then(80, "loop", "idle");
        }

        @Override
        public List<String> animations() {
            return List.of("idle", "redeem");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "player", "me/fixfis/sUHCore/mobs/SUHMobs$19", "onRightClickAtEntityEvent"));
        }
    }),
    PORTAL(new FStandEntity("portal"){

        @Override
        protected void initViewStand(ArmorStand entity) {
            entity.setSmall(true);
            entity.getAttribute(Attribute.SCALE).setBaseValue(4.0);
            ItemStack stack = new ItemStack(Material.STICK);
            stack.setData(DataComponentTypes.ITEM_MODEL, (Object)Key.key((String)"suhcore", (String)"portal"));
            entity.getEquipment().setHelmet(20.getItemstackWhitItemModel(Material.STICK, "portal"));
        }

        @Override
        protected void onRightClickAtEntityEvent(Player player, ArmorStand entity, PlayerInteractAtEntityEvent event) {
            new RevivirIntefaz(player);
        }
    }),
    PORTAL_MINIGAMES(new FStandEntity("minigames"){

        @Override
        protected void initViewStand(ArmorStand entity) {
            entity.setSmall(true);
            entity.getAttribute(Attribute.SCALE).setBaseValue(20.0);
            ItemStack stack = new ItemStack(Material.STICK);
            stack.setData(DataComponentTypes.ITEM_MODEL, (Object)Key.key((String)"suhcore", (String)"minigames_zone"));
            entity.getEquipment().setHelmet(21.getItemstackWhitItemModel(Material.STICK, "portal"));
        }
    }),
    LOOTCHEST(new FStandEntity("lootchest"){

        @Override
        protected void initViewStand(ArmorStand entity) {
            entity.getEquipment().setHelmet(22.getItemstackWhitItemModel(Material.STICK, "chest"));
            LootTable.lootables.put(entity.getUniqueId(), new ArrayList());
        }

        @Override
        protected void onRightClickAtEntityEvent(Player player, ArmorStand entity, PlayerInteractAtEntityEvent event) {
            FLootEntity.onDectectedLoot(entity, player);
        }
    });

    private final FEntity<? extends Entity> fEntity;

    private SUHMobs(FEntity<? extends Entity> fEntity) {
        this.fEntity = fEntity;
    }

    public FEntity<? extends Entity> getfEntity() {
        return this.fEntity;
    }

    public void saveData() {
        FLivingEntities fMonster;
        FEntity<? extends Entity> fEntity = this.fEntity;
        if (fEntity instanceof FLivingEntities) {
            fMonster = (FLivingEntities)fEntity;
            fMonster.saveProb();
        }
        if ((fEntity = this.fEntity) instanceof FMonster) {
            fMonster = (FMonster)fEntity;
            ((FMonster)fMonster).saveData();
        }
    }

    public void loadData() {
        FLivingEntities fMonster;
        FEntity<? extends Entity> fEntity = this.fEntity;
        if (fEntity instanceof FLivingEntities) {
            fMonster = (FLivingEntities)fEntity;
            fMonster.loadProb();
        }
        if ((fEntity = this.fEntity) instanceof FMonster) {
            fMonster = (FMonster)fEntity;
            ((FMonster)fMonster).loadData();
        }
    }
}

